<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Use Table -->
	<xsl:template name="PrintUseTable">

		<xsl:param name="class"></xsl:param>
		<xsl:param name="type"></xsl:param>
		<xsl:param name="nodeSet"></xsl:param>
		<xsl:variable name="title">
			<xsl:choose>
				<xsl:when test="$type='method_return_type'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'methods_that_return_the_class'"></xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$type='parameter_type'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'methods_that_param_class'"></xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$type='field_type'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'field_type_descr'"></xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$type"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:variable name="element" select="key('all-by-id', @element)"></xsl:variable>
				<!--xsl:value-of select="@element"></xsl:value-of-->
				<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
				<xsl:variable name="parent" select="$element/.."></xsl:variable>
				
				<xsl:choose>
					<xsl:when test="$localName='Parameter'">
						<xsl:call-template name="printRow">
							<xsl:with-param name="element" select="$parent"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="printRow">
							<xsl:with-param name="element" select="$element"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>

	<xsl:template name="printRow">
		<xsl:param name="element"></xsl:param>
		
		<xsl:variable name="description">
			<xsl:apply-templates select="$element" mode="getDescription"/>
		</xsl:variable>

		<tr class="TableRow">
			<td width="15%">
				<b>
					<xsl:apply-templates select="$element" mode="HRefWithImgLoad">
						<xsl:with-param name="isName" select="'1'"/>
					</xsl:apply-templates>
				</b>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="string-length($description) &gt; 0">
						<xsl:value-of select="$description"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
